<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../../app/caja/cCaja.php");
$oCaja = new cCaja();
require_once ("../../app/empresa/cEmpresa.php");
$oEmpresa = new cEmpresa();

require_once ("../../app/notalmacendetalle_cst/cNotalmacendetalle_cst.php");
$oNotalmacendetalle_cst = new cNotalmacendetalle_cst();

require_once("../../app/producto/cProductoespecificacion.php");
$oProductoespecificacion = new cProductoespecificacion();
require_once ("../../app/producto/cCatalogo.php");
$oCatalogo = new cCatalogo();


$fec = date('Y-m-d');
require_once ("../../app/formatos/formato.php");
require_once ("../../app/formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE NOTAS ALMACEN ".$caj_nom.' '.$mon_abr)
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  
  $titulos = array(
  'FECHA',
  'NUM. DOC.',
  'ALMACEN',
  'TIPO',
  'OBSERVACION',
  'PRODUCTO',
  'COLOR',
  'MARCA',
  'CANTIDAD'
  );
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'REPORTE DE NOTA DE ALMACEN');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	$c = $c+1;
  
	$letracolumn = 0;
  
	for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
	}
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	$c = $c+1;
 

	$dtsa=$oNotalmacendetalle_cst->mostrar_filtrocondetalles($_GET['fec1'],$_GET['fec2'],$_GET['alm_id'],$_GET['tip'],$_GET['numdoc']);
	$num_rows= mysqli_num_rows($dtsa);

	if($num_rows>0){
	
	while($dt1 = mysqli_fetch_array($dtsa))
	{ 					
		 $can = $dt1['tb_notaalmacendetalle_can'] * 1;
		$esp_id = $dt1['tb_especificacion_id'];

		$dts2=$oCatalogo->mostrarUno($dt1['tb_catalogo_id'],$dt1['tb_marca_id']);
		$dt2 = mysqli_fetch_array($dts2);
		$pronom = $dt2['tb_producto_nom'];
		

		$dtses=$oProductoespecificacion->mostrar_unoinfo($esp_id);
		$num_rows= mysqli_num_rows($dtses);

		$dtes = mysqli_fetch_array($dtses);
		
		$colnom = $dtes['tb_color_nom'];
		$colcod = $dtes['tb_color_cod'];
		$memramnom = $dtes['tb_memoriaram_nom'];
		$menintnom = $dtes['tb_memoriainterna_nom'];
		
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt1['tb_notaalmacen_fec']))
    ->setCellValue('B'.$c, $dt1['tb_notaalmacen_numdoc']) 
    ->setCellValue('C'.$c, $dt1['tb_almacen_nom']) 
    ->setCellValue('D'.$c, $dt1['tb_notaalmacentipo_nom'])  
    ->setCellValue('E'.$c, $dt1['tb_notaalmacen_des'])
    ->setCellValue('F'.$c, $pronom.' RAM:'.$memramnom.' M.I:'.$menintnom) 
    ->setCellValue('G'.$c, $colnom)   
    ->setCellValue('H'.$c, $dt1['tb_marca_nom'])   
     ->setCellValue('I'.$c, $can);
	
    $objPHPExcel->getActiveSheet(0)->getStyle("I$c:I$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	
	
	}
	mysqli_free_result($dtsa);

    /*
    $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
     ->setCellValue('H'.$c, '')
    ->setCellValue('I'.$c, '');
    
    
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:I$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	
	$objPHPExcel->getActiveSheet(0)->getStyle("I$c:I$c")->getNumberFormat()->setFormatCode('0.00');
	*/
	
	$c = $c +1;
	
	
	
	}else{
		$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'SIN DATOS');
		$c = $c +1;
		
	}
		

	
    for($z = 'A'; $z <= 'L'; $z++){
      $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
    }
	
	$objPHPExcel->getActiveSheet()->setTitle('REPORTE DE NOTA DE ALMACEN');
	
	$nombre_archivo="REPORTE DE NOTA ALMACEN ".date('d-m-Y H-i:s').".xlsx";

    $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    
    $objWriter->save('php://output');
    exit;
?>