<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../../app/caja/cCaja.php");
$oCaja = new cCaja();
require_once ("../../app/empresa/cEmpresa.php");
$oEmpresa = new cEmpresa();

require_once ("../../app/devolucionclientedetalle_cst/cDevolucionclientedetalle_cst.php");
$oDevolucionclientedetalle_cst = new cDevolucionclientedetalle_cst();

require_once("../../app/producto/cProductoespecificacion.php");
$oProductoespecificacion = new cProductoespecificacion();

$fec = date('Y-m-d');
require_once ("../../app/formatos/formato.php");
require_once ("../../app/formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE DEVOLUCION CLIENTE ")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("Reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  $titulos = array(
  'FECHA',
  'FECHA VEN.',
  'DEVOLUCION',
  'USUARIO',
  'VENTA',
  'VENDEDOR',
  'CLIENTE',
  'PRODUCTO',
  'ESTADO',
  'OBSERVACION',
  'OBSERVACION PROV.',
  'DETALLE FINAL',
  'OBSERVACION REPARACION',
  'GASTO REPARACION',
  'GASTO ADMINISTRATIVO',
  'TOTAL'
  );
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("B$c", 'REPORTE DE DEVOLUCION CLIENTE');
	//$objPHPExcel->getActiveSheet()->margeCells("A1:G1");
	$objPHPExcel->getActiveSheet()->getStyle("A$c:P$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:P$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	$c = $c+1;
  
	$letracolumn = 0;
  
	for ($i=0; $i < count($titulos) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulos[$i]);
	}
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	$c = $c+1;
 

	$dtsa=$oDevolucionclientedetalle_cst->mostrar_filtrocondetalles($_GET['punven_id'],$_GET['dev_est'],$_GET['fec1'],$_GET['fec2']);
	$num_rows= mysqli_num_rows($dtsa);

	if($num_rows>0){
	
	while($dt1 = mysqli_fetch_array($dtsa))
	{ 					
		$can = $dt1['tb_ventadetalle_can'] * 1;
		$esp_id = $dt1['tb_especificacion_id'];

		$dtses=$oProductoespecificacion->mostrar_unoinfo($esp_id);
		//$num_rows= mysqli_num_rows($dtses);

		$dtes = mysqli_fetch_array($dtses);
		
		$colnom = $dtes['tb_color_nom'];
		$colcod = $dtes['tb_color_cod'];
		$memramnom = $dtes['tb_memoriaram_nom'];
		$menintnom = $dtes['tb_memoriainterna_nom'];

		
		if($dt1['tb_devolucioncliente_est']==1){
			$est = 'RECEPCIONADO';			
		}else if($dt1['tb_devolucioncliente_est']==2){
			$est = 'EN PROCESO';			
		}else if($dt1['tb_devolucioncliente_est']==3){
			$est = 'FINALIZADO/NO REPARADO';			
		}else if($dt1['tb_devolucioncliente_est']==4){
			$est = 'FINALIZADO/REPARADO';			
		}else if($dt1['tb_devolucioncliente_est']==5){
			$est = 'FINALIZADO/SIN GARANTIA';			
		}
	
		$tot_rep += $dt1['tb_devolucioncliente_cosrep'];
		$tot_adm += $dt1['tb_devolucioncliente_cosadm'];
		$tot_tot += $dt1['tb_devolucioncliente_tot'];
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt1['tb_devolucioncliente_fec']))
    ->setCellValue('B'.$c, mostrarFecha($dt1['tb_devolucioncliente_fecfin']))
    ->setCellValue('C'.$c, $dt1['tb_devolucioncliente_numdoc']) 
    ->setCellValue('D'.$c, $dt1['usudev']) 
    ->setCellValue('E'.$c, $dt1['tb_venta_numdoc'])  
    ->setCellValue('F'.$c, $dt1['usuven'])
    ->setCellValue('G'.$c, $dt1['tb_cliente_nom']) 
    ->setCellValue('H'.$c, $dt1['tb_producto_nom'].'RAM:'.$memramnom.' M.I:'.$menintnom) 
    ->setCellValue('I'.$c, $est)   
    ->setCellValue('J'.$c, $dt1['tb_devolucioncliente_obs1'])   
    ->setCellValue('K'.$c, $dt1['tb_devolucioncliente_obs2'])   
    ->setCellValue('L'.$c, $dt1['tb_devolucioncliente_obs3'])   
    ->setCellValue('M'.$c, $dt1['tb_devolucioncliente_obs4'])   
    ->setCellValue('N'.$c, formato_money3($dt1['tb_devolucioncliente_cosrep']))
    ->setCellValue('O'.$c, formato_money3($dt1['tb_devolucioncliente_cosadm']))
    ->setCellValue('P'.$c, formato_money3($dt1['tb_devolucioncliente_tot']));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("N$c:P$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	
	}
	mysqli_free_result($dtsa);

    
    $objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, 'TOTAL')
    ->setCellValue('B'.$c, '')
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '')
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
    ->setCellValue('H'.$c, '')
    ->setCellValue('I'.$c, '')
    ->setCellValue('J'.$c, '')
    ->setCellValue('K'.$c, '')
    ->setCellValue('L'.$c, '')
    ->setCellValue('M'.$c, '')
    ->setCellValue('N'.$c, formato_money($tot_rep))
    ->setCellValue('O'.$c, formato_money($tot_adm))
    ->setCellValue('P'.$c, formato_money($tot_tot));
    
    
	$objPHPExcel->getActiveSheet()->getStyle("A$c:P$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:P$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("N$c:P$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;
	
	
	
	}else{
		$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'SIN DATOS');
		$c = $c +1;
		
	}
		

	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('REPORTE DEVOLUCION CLIENTE');
	
	$nombre_archivo="REPORTE DEVOLUCION CLIENTE ".date('d-m-Y H-i:s').".xlsx";

    $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    $objWriter->save('php://output');
    exit;
?>