<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");

require_once ("../valorizado_cst/cValorizado_cst.php");
$oValorizado_cst = new cValorizado_cst();
require_once("../preciogestion/cPreciogestion.php");
$oPreciogestion = new cPreciogestion();
require_once ("../stock/cStock.php");
$oStock = new cStock();

$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("MOVIMIENTO STOCK")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;

  $titulosColumnascompras = array(
  'NOMBRE',
  'COLOR',
  'MARCA',
  'STOCK ACTUAL',
  'TOTAL ENTRADAS',
  'COSTO',
  'TOTAL SALIDAS',
  'VENTA', 
  'STOCK CONSULTA', 
  'UTILIDAD'
  );
  
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'MOVIMIENTO STOCK');
    $objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  
  $letracolumn = 0;
  
  //// COMPRAS
  for ($i=0; $i < count($titulosColumnascompras) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnascompras[$i]);
  }
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
		$c = $c+1;
 
		$dtc1 = $oValorizado_cst->mostrar_filtro($_GET['alm_id'],$_GET['fec_1'],$_GET['fec_2']);
		while($dt1 = mysqli_fetch_array($dtc1)){
		
			$dtspre = $oPreciogestion->mostrar_precioxpuntoventa($dt1['tb_especificacion_id'],$_GET['punven_id']);		
			$dtp = mysqli_fetch_array($dtspre);
			$preven = $dtp['tb_precioproductoespecificacion_preven'];
			$precos = $dtp['tb_precioproductoespecificacion_precom'];		
			$uti = $preven - $precos;					
		
		
			
		if($_GET['alm_id']>0)$stock = mysqli_fetch_array($oStock->stock_por_presentacion($dt1['tb_presentacion_id'],$dt1['tb_marca_id'],$dt1['tb_especificacion_id'],$_GET['alm_id']))['tb_stock_num']; 
		
		$stockrestante = $dt1['canentrada'] - $dt1['cansalida'];		
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, $dt1['tb_producto_nom'].'RAM:'.$dt1['tb_memoriaram_nom'].' M.I:'.$dt1['tb_memoriainterna_nom'])
    ->setCellValue('B'.$c, $dt1['tb_color_nom'])
    ->setCellValue('C'.$c, $dt1['tb_marca_nom'])
    ->setCellValue('D'.$c, $stock * 1 )
    ->setCellValue('E'.$c, $dt1['canentrada']*1) 
    ->setCellValue('F'.$c, formato_money($precos)) 
    ->setCellValue('G'.$c, $dt1['cansalida']*1)
    ->setCellValue('H'.$c, formato_money($preven))
    ->setCellValue('I'.$c, $stockrestante * 1 )
    ->setCellValue('J'.$c, formato_money($uti));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("F$c:J$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
		
		
		$totalprecos += moneda_mysql($precos);
		$totalpreven += moneda_mysql($preven);
		$totaluti += moneda_mysql($uti);
		
		}
		
	mysqli_free_result($dtc1);
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '') 
    ->setCellValue('E'.$c, '') 
    ->setCellValue('F'.$c, formato_money($totalprecos))
	->setCellValue('G'.$c, '') 
    ->setCellValue('H'.$c, formato_money($totalpreven))
	->setCellValue('I'.$c, '') 
    ->setCellValue('J'.$c, formato_money($totaluti));
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("F$c:J$c")->getNumberFormat()->setFormatCode('0.00');
	
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('MOVIMIENTO STOCK');
	
	$nombre_archivo="MOVIMIENTO STOCK ".date('d-m-Y H-i:s').".xlsx";
	
	 $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
$objWriter->save('php://output');
exit;
?>