<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");

require_once("../producto/cProductoespecificacion.php");
$oProductoespecificacion = new cProductoespecificacion();
require_once ("../stockimei/cStockimei.php");
$oStockimei = new cStockimei();
require_once ("../preciogestion/cPreciogestion.php");
$oPreciogestion = new cPreciogestion();

$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("STOCK DE IMEIS")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  
  $titulosColumnascompras = array(
  'ALMACEN',
  'NOMBRE',
  'COLOR',
  'MARCA',
  'FECHA INGRESO',
  'CANTIDAD',
  'IMEI',
  'COSTO',
  'VENTA', 
  'UTILIDAD'
  );
  
  
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'STOCK IMEIS');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  
  $letracolumn = 0;
  
  //// COMPRAS
  for ($i=0; $i < count($titulosColumnascompras) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnascompras[$i]);
  }
  
  	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
  
		$c = $c+1;
 
		$dtc1 = $oStockimei->filtrar($_GET['alm_id']);
		while($dt1 = mysqli_fetch_array($dtc1)){
		
								$dtspre = $oPreciogestion->mostrar_precioxpuntoventa($dt1['tb_especificacion_id'],$dt1['tb_puntoventa_id']);		
								$numrowspre = mysqli_num_rows($dtspre);
								
								$dtp = mysqli_fetch_array($dtspre);
								$preven = $dtp['tb_precioproductoespecificacion_preven'];
								$precos = $dtp['tb_precioproductoespecificacion_precom'];
								
					
					
								
								$dtses=$oProductoespecificacion->mostrar_unoinfo($dt1['tb_especificacion_id']);

								$dtes = mysqli_fetch_array($dtses);								
								$colnom = $dtes['tb_color_nom'];
								$colcod = $dtes['tb_color_cod'];
								$memramnom = $dtes['tb_memoriaram_nom'];
								$menintnom = $dtes['tb_memoriainterna_nom'];
								
								
								$uti = $preven - $precos;
		
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, $dt1['tb_almacen_nom'])
    ->setCellValue('B'.$c, $dt1['tb_producto_nom'].'RAM:'.$memramnom.' M.I:'.$menintnom)
    ->setCellValue('C'.$c, $colnom)
    ->setCellValue('D'.$c, $dt1['tb_marca_nom'])
    ->setCellValue('E'.$c, mostrarFecha($dt1['tb_especificacionimei_fec']))
    ->setCellValue('F'.$c, 1) 
    ->setCellValue('G'.$c, $dt1['tb_especificacionimei_nom'].' ') 
    ->setCellValue('H'.$c, formato_money($precos))
    ->setCellValue('I'.$c, formato_money($preven))
    ->setCellValue('J'.$c, formato_money($uti));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("H$c:J$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
		
		
		$totalprecos += moneda_mysql($precos);
		$totalpreven += moneda_mysql($preven);
		$totaluti += moneda_mysql($uti);
		
		}
		
	mysqli_free_result($dtc1);
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '') 
    ->setCellValue('E'.$c, '') 
    ->setCellValue('F'.$c, '') 
    ->setCellValue('G'.$c, '') 
    ->setCellValue('H'.$c, formato_money($totalprecos))
    ->setCellValue('I'.$c, formato_money($totalpreven))
    ->setCellValue('J'.$c, formato_money($totaluti));
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	
	$objPHPExcel->getActiveSheet(0)->getStyle("H$c:J$c")->getNumberFormat()->setFormatCode('0.00');
	
	
for($z = 'A'; $z <= 'L'; $z++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
}
	
	$objPHPExcel->getActiveSheet()->setTitle('STOCK DE IMEIS');
	
	$nombre_archivo="STOCK IMEIS ".date('d-m-Y H-i:s').".xlsx";
	
	 $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
$objWriter->save('php://output');
exit;
?>