<?php
if (PHP_SAPI == 'cli')
  die('Se visualiza solamente desde un navegador.');
require '../../libreriasphp/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

date_default_timezone_set('America/Lima');
session_start();
require_once ("../../config/Cado.php");
require_once ("../compra/cCompra.php");
$oCompra = new cCompra();
require_once ("../venta/cVenta.php");
$oVenta = new cVenta();
require_once ("../venta/cVentapago.php");
$oVentapago = new cVentapago();
require_once ("../notacredito/cNotacredito.php");
$oNotacredito = new cNotacredito();
require_once("../tipocambio/cTipocambio.php");
$oTipocambio = new ctipocambio();
$fec = date('Y-m-d');
require_once ("../formatos/formato.php");
require_once ("../formatos/fechas.php");
// Create new PHPExcel object
$objPHPExcel = new Spreadsheet();
// Set document properties
$objPHPExcel->getProperties()->setCreator("https://infosisperu.com")
->setLastModifiedBy("https://infosisperu.com")
->setTitle("REPORTE CONSOLIDADO IGV")
->setSubject("Reporte")
->setDescription("Reporte generado por https://infosisperu.com")
->setKeywords("")
->setCategory("reporte excel");
$objPHPExcel->setActiveSheetIndex(0);
$c=1;
  
  $titulosColumnascompras = array(
  'FECHA',
  'DOCUMENTO',
  'RUC',
  'PROVEEDOR', 
  'PV', 
  'VALOR', 
  'IGV',
  'TOTAL'
  );
  $titulosColumnasventas = array(
  'FECHA',
  'FECHA V.',
  'DOCUMENTO',
  'FORMA PAGO',
  'RUC',
  'CLIENTE', 
  'PV', 
  'VALOR', 
  'IGV',
  'TOTAL'
  );
  
  $titulosColumnasnotas = array(
  'FECHA',
  'DOCUMENTO',
  'RUC',
  'CLIENTE', 
  'PV', 
  'FECHA DOC. RELACIONADO', 
  'DOC. RELACIONADO', 
  'VALOR', 
  'IGV',
  'TOTAL'
  );
  $letras = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
  
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'COMPRAS');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:H$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:H$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  
  $letracolumn = 0;
  
  //// COMPRAS
  for ($i=0; $i < count($titulosColumnascompras) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnascompras[$i]);
  }
  
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
  $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	
		$c = $c+1;
 
	
		
		$dtc1d = $oCompra->mostrar_detalle_des($_GET['mes'],$_GET['anio'],$_GET['punven_id']);
		while($dt = mysqli_fetch_array($dtc1d)){
														
		if($dt['tb_moneda_id']== 2){
				$rs = $oTipocambio->consultar(fecha_mysql($dt['tb_compra_fec']));  
				$r = mysqli_fetch_array($rs);	
				$tipcam = formato_money3($r['tb_tipocambio_dolsun']);
		}
		else{
				$tipcam = '1.00';	
		}
		
		$valvenc = 0;
		$igvc = 0;
		$totc = 0;		
		$totc = $dt['tb_compra_tot'] * $tipcam;
		$valvenc = $totc ;
		$igvc = 0;		
		$totalc  += $totc; 
		$igvtotalc  += $igvc; 
		$valventotalc  += $valvenc; 
		
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt['tb_compra_fec']))
    ->setCellValue('B'.$c, $dt['tb_documento_abr'].' - '.$dt['tb_compra_numdoc'])    
    ->setCellValue('C'.$c, $dt['tb_proveedor_doc'])
    ->setCellValue('D'.$c, $dt['tb_proveedor_nom'])
    ->setCellValue('E'.$c, $dt['tb_puntoventa_alias'])   
    ->setCellValue('F'.$c, formato_money($valvenc))
    ->setCellValue('G'.$c, formato_money($igvc))
    ->setCellValue('H'.$c, formato_money($totc));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("F$c:H$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
		
		
		}
		
		
		mysqli_free_result($dtc1d);
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '') 
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, formato_money($valventotalc))
    ->setCellValue('G'.$c, formato_money($igvtotalc))
    ->setCellValue('H'.$c, formato_money($totalc));
	
    $objPHPExcel->getActiveSheet()->getStyle("A$c:H$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:H$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("F$c:H$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;

	
	$c = $c+1;
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'VENTAS');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  	
	
	$letracolumn = 0;
  ///// VENTAAAAAS
      for ($i=0; $i < count($titulosColumnasventas) ; $i++) { 
        $letracolumn = $i;
        $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnasventas[$i]);
      }
    $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
    $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
  
	$c = $c+1;
		
		$dtc1d = $oVenta->mostrar_detalle_des($_GET['mes'],$_GET['anio'],$_GET['punven_id']);
		while($dt = mysqli_fetch_array($dtc1d)){
		
		
		if($dt['tb_venta_estsun']==2){
			$valvenv = 0;
			$igvv = 0;
			$totv = 0;
		}else{
		
		if($dt['tb_moneda_id']==2){
				$rs = $oTipocambio->consultar(fecha_mysql($dt['tb_venta_fec']));  
				$r = mysqli_fetch_array($rs);	
				$tipcam = formato_money3($r['tb_tipocambio_dolsun']);
		}
		else{
				$tipcam = '1.00';	
		}
		
		
		$valvenv = 0;
		$igvv = 0;
		$totv = 0;
		
		$totv = $dt['tb_venta_tot'] * $tipcam;
		$valvenv = $totv;
		$igvv = 0;
		}
		
		$totalv  += $totv; 
		$igvtotalv  += $igvv; 
		$valventotalv  += $valvenv; 
		
		
		
		$dtsvp = $oVentapago->filtrar($dt['tb_venta_id']);
		$numrowvenpag = mysqli_num_rows($dtsvp);
		
		if($numrowvenpag>0){
			$vp = mysqli_fetch_array($dtsvp);	
			if($vp['tb_formapago_id']==1) $forpag = 'CONTADO';
			if($vp['tb_formapago_id']==2) $forpag =  'CREDITO';
		}
		
		
		
		$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt['tb_venta_fec']))
     ->setCellValue('B'.$c, mostrarFecha($dt['tb_venta_ven']))
    ->setCellValue('C'.$c, $dt['tb_documento_abr'].' - '.$dt['tb_venta_numdoc'])    
    ->setCellValue('D'.$c, $forpag)
    ->setCellValue('E'.$c, $dt['tb_cliente_doc'])
    ->setCellValue('F'.$c, $dt['tb_cliente_nom'])
    ->setCellValue('G'.$c, $dt['tb_puntoventa_alias'])   
    ->setCellValue('H'.$c, formato_money($valvenv))
    ->setCellValue('I'.$c, formato_money($igvv))
    ->setCellValue('J'.$c, formato_money($totv));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("G$c:I$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;
	
		
		}
		
		mysqli_free_result($dtc1d);
	
	
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '') 
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
    ->setCellValue('H'.$c, formato_money($valventotalv))
    ->setCellValue('I'.$c, formato_money($igvtotalv))
    ->setCellValue('J'.$c, formato_money($totalv));
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	$objPHPExcel->getActiveSheet(0)->getStyle("G$c:I$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;

	$c = $c+1;
	
	$totalv = 0; 
	$igvtotalv = 0; 
	$valventotalv  = 0; 
	
	$objPHPExcel->getActiveSheet()->setCellValue("A$c", 'NOTA DE CREDITO');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('ffffff');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('0d47a1');
	
	$c = $c+1;
  	
	$letracolumn = 0;
  ///// NOTA DE CREDITO
  for ($i=0; $i < count($titulosColumnasnotas) ; $i++) { 
    $letracolumn = $i;
    $objPHPExcel->getActiveSheet()->setCellValue($letras[$i].$c, $titulosColumnasnotas[$i]);
	}
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFont()->getColor()->setRGB('000000');
    $objPHPExcel->getActiveSheet()->getStyle("A$c:".$letras[$letracolumn]."$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('8C9EFF');
	
	$c = $c+1;
	

		$dtc1d = $oNotacredito->mostrar_detalle_des($_GET['mes'],$_GET['anio'],$_GET['punven_id']);
		while($dt = mysqli_fetch_array($dtc1d)){
		
		
		if($dt['tb_notacredito_estsun']==2){
			$valvenv = 0;
		$igvv = 0;
		$totv = 0;
	}else{	
	
		if($dt['tb_moneda_id']==2){
				$rs = $oTipocambio->consultar(fecha_mysql($dt['tb_notacredito_fec']));  
				$r = mysqli_fetch_array($rs);	
				$tipcam = formato_money3($r['tb_tipocambio_dolsun']);
		}
		else{
				$tipcam = '1.00';	
		}
		
		
		$valvenv = 0;
		$igvv = 0;
		$totv = 0;
		
		$totv = $dt['tb_notacredito_tot'] * $tipcam;
		$valvenv = $totv;
		$igvv = 0;
	}
		
		$totalv  += $totv; 
		$igvtotalv  += $igvv; 
		$valventotalv  += $valvenv; 
		
		$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, mostrarFecha($dt['tb_notacredito_fec']))
    ->setCellValue('B'.$c, $dt['tb_documento_abr'].' - '.$dt['tb_notacredito_numdoc'])    
    ->setCellValue('C'.$c, $dt['tb_cliente_doc'])
    ->setCellValue('D'.$c, $dt['tb_cliente_nom'])
    ->setCellValue('E'.$c, $dt['tb_puntoventa_alias'])  
    ->setCellValue('F'.$c, mostrarFecha($dt['tb_venta_fec']))   
    ->setCellValue('G'.$c, $dt['tb_venta_numdoc'])   	
    ->setCellValue('H'.$c, formato_money($valvenv))
    ->setCellValue('I'.$c, formato_money($igvv))
    ->setCellValue('J'.$c, formato_money($totv));
	
    $objPHPExcel->getActiveSheet(0)->getStyle("H$c:J$c")->getNumberFormat()->setFormatCode('0.00');
    $c++;	
		
			}
		
		mysqli_free_result($dtc1d);
	
	
	
	$objPHPExcel->getActiveSheet(0)
    ->setCellValue('A'.$c, '')
    ->setCellValue('B'.$c, '')    
    ->setCellValue('C'.$c, '')
    ->setCellValue('D'.$c, '') 
    ->setCellValue('E'.$c, '')
    ->setCellValue('F'.$c, '')
    ->setCellValue('G'.$c, '')
    ->setCellValue('H'.$c, formato_money($valventotalv))
    ->setCellValue('I'.$c, formato_money($igvtotalv))
    ->setCellValue('J'.$c, formato_money($totalv));
	
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFont()->getColor()->setRGB('000000');
	$objPHPExcel->getActiveSheet()->getStyle("A$c:J$c")->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFEA00');
	
	$objPHPExcel->getActiveSheet(0)->getStyle("H$c:J$c")->getNumberFormat()->setFormatCode('0.00');
	$c = $c +1;

	$c = $c+1;
	
	
    for($z = 'A'; $z <= 'L'; $z++){
      $objPHPExcel->getActiveSheet()->getColumnDimension($z)->setAutoSize(TRUE);
    }
	
	$objPHPExcel->getActiveSheet()->setTitle('CONSOLIDADO IGV ');
	
	$nombre_archivo="CONSOLIDADO IGV ".date('d-m-Y H-i:s').".xlsx";

    $objWriter = new Xlsx($objPHPExcel);
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="'. urlencode($nombre_archivo).'"');
    
    
    $objWriter->save('php://output');
    exit;
?>